<?php

namespace App\Http\Controllers\Site\Fee;

use App\Models\Academic\AcademicFeeGroup;
use App\Models\Academic\AcademicWaiverType;
use App\Models\Site\Fee\SiteFeeWaiverOfferHistory;
use App\Models\Site\Fee\SiteStudentFeeFineAllocation;
use App\Models\Site\Fee\SiteStudentFeeWaiverOfferHistory;
use App\Models\Student\StudentHistory;
use DB;
use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\Fee\SiteStudentFeeGenerate;
use JsonSchema\Exception\ValidationException;
use Response;
use Session;

class StudentWaiverHistoryController extends Controller
{
    private $siteStudentFeeWaiverOfferHistory;

    public function __construct(SiteStudentFeeWaiverOfferHistory $siteStudentFeeWaiverOfferHistory)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
        $this->siteStudentFeeWaiverOfferHistory = $siteStudentFeeWaiverOfferHistory;

    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = 'Fee Head List';
        return view('default.admin.sites.fee.student-waiver-history.view', compact('viewType'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    public function getInstentWaiverBaseTypeStudentList(Request $request){
//        return $request;
        $siteStudentIDs=$this->returnSiteStudentList($request);

        $waiverList=AcademicWaiverType::get();

        return response()->json([$siteStudentIDs, $waiverList], 200, [], JSON_NUMERIC_CHECK);

    }

    public function getSiteBaseClassFeeListForWaiver(Request $request){
//        return $request;
        $siteGroupFeeList=$this->returnSiteGroupFeeList($request);
        $siteStudentList=$this->returnSiteStudentList($request);
       // dd('fsfsf');

    

        $siteGroupFeeListIDs=[];
        foreach ($siteGroupFeeList as $key => $value) {
            $siteGroupFeeListIDs[]=$value['id'];
        }

        if($request->student_history_id){
            $studentWaiverGeneratedList=SiteStudentFeeWaiverOfferHistory::whereIn('site_student_fee_fine_allocation_id', $siteGroupFeeListIDs)
                ->where('fee_head_type_id', $request->checked_admission_examination_general_id)
                ->where('student_history_id', $request->student_history_id)
                ->where('academic_waiver_type_id', $request->academic_waiver_type_id)
                ->get();

            if(count($studentWaiverGeneratedList)>0){
                $waiverGeneratedList=$studentWaiverGeneratedList;
            }else{
                $waiverGeneratedList=SiteFeeWaiverOfferHistory::whereIn('site_student_fee_fine_allocation_id', $siteGroupFeeListIDs)
                    ->where('fee_head_type_id', $request->checked_admission_examination_general_id)
                    ->get();
            }

        }else{
            $section_id = $request->academic_section_id;
            $waiverGeneratedList=SiteFeeWaiverOfferHistory::whereIn('site_student_fee_fine_allocation_id', $siteGroupFeeListIDs)
                ->where('fee_head_type_id', $request->checked_admission_examination_general_id)
                ->when($section_id, function ($query) use($section_id){
                    return $query->where('academic_section_id', $section_id);
                })
                ->where('academic_waiver_type_id', $request->academic_waiver_type_id)
                ->get();
        }

  
      //  dd($siteGroupFeeList);

        $siteGroupFeeFinalList=[];
        $siteGroupFeeFinalArr=Array();
        $keyss=0;
        foreach ($siteGroupFeeList as $key => $value) {

            $checkIfPresent=$waiverGeneratedList->where('site_student_fee_fine_allocation_id',$value['id'])->first();

            if($checkIfPresent){

                $siteGroupFeeFinalArr['select_fee_sub_head_id']=true;
                $siteGroupFeeFinalArr['waiver_amount']=$checkIfPresent->amount;
                $siteGroupFeeFinalArr['percantage_status']=$checkIfPresent->percantage_status;
                $siteGroupFeeFinalArr['demand_slip_create_status']=$checkIfPresent->demand_slip_create_status;
            }else{
                $siteGroupFeeFinalArr['select_fee_sub_head_id']=false;
                $siteGroupFeeFinalArr['waiver_amount']=0;
                $siteGroupFeeFinalArr['percantage_status']=false;
                $siteGroupFeeFinalArr['demand_slip_create_status']=0;
            }
            $siteGroupFeeFinalList[$keyss]=array_merge($siteGroupFeeFinalArr, is_array($value)?$value:$value->toArray());
            $keyss++;
        }

        $studentWaiverList=[];
        foreach($siteStudentList as $stdkey=>$studentHistory){

            $siteGroupFeeFinalList2=[];
            $siteGroupFeeFinalArr2=Array();
            $keys=0;
            foreach ($siteGroupFeeList as $key => $value) {

                $checkIfPresent=$waiverGeneratedList->where('site_student_fee_fine_allocation_id',$value['id'])->first();

                if($checkIfPresent){

                    $siteGroupFeeFinalArr2['select_fee_sub_head_id']=true;
                    $siteGroupFeeFinalArr2['waiver_amount']=$checkIfPresent->amount;
                    $siteGroupFeeFinalArr2['percantage_status']=$checkIfPresent->percantage_status;
                    $siteGroupFeeFinalArr2['demand_slip_create_status']=$checkIfPresent->demand_slip_create_status;
                }else{
                    $siteGroupFeeFinalArr2['select_fee_sub_head_id']=false;
                    $siteGroupFeeFinalArr2['waiver_amount']=0;
                    $siteGroupFeeFinalArr2['percantage_status']=false;
                    $siteGroupFeeFinalArr2['demand_slip_create_status']=0;
                }
                $siteGroupFeeFinalList2[$keys]=array_merge($siteGroupFeeFinalArr2, is_array($value)?$value:$value->toArray());
                $keys++;

            }

            
            $studentWaiverList[$stdkey]['select_student']=true;
            $studentWaiverList[$stdkey]['student_history_id']=$studentHistory->id;
            $studentWaiverList[$stdkey]['user_id']=$studentHistory->user_id;
            $studentWaiverList[$stdkey]['full_name']=$studentHistory->full_name;
            $studentWaiverList[$stdkey]['student_roll_number']=$studentHistory->student_roll_number;
            $studentWaiverList[$stdkey]['username']=$studentHistory->username;
            $studentWaiverList[$stdkey]['feeFinalList']=$siteGroupFeeFinalList2;

       //     $studentHistoryArray[$std_kyes]['fee']=
        }

        return response()->json([$siteGroupFeeFinalList, $studentWaiverList], 200, [], JSON_NUMERIC_CHECK);

    }

    private function returnSiteGroupFeeList(Request $request){
        $data = $request->all();

        $FeeGroupsGlobalID=AcademicFeeGroup::whereIn('head_key', ['global'])->pluck('id');

        $FeeGroupsClassStudentID=AcademicFeeGroup::whereIn('head_key', ['classbase','studentbase'])->pluck('id');

        $siteGroupFeeList=Array();
        if($request->checked_fee_head_id!=null  && $request->academic_class_id!=null){

            $SiteFeeList=SiteStudentFeeFineAllocation::with(['academicFeeHead', 'academicFeeGroup','academicFeeSubHead' ])
                ->where('academic_fee_head_id',$request->checked_fee_head_id)
                ->where('academic_version_id',$request->academic_version_id)
                ->where('academic_shift_id',$request->academic_shift_id)
                ->where('academic_year_id',$request->academic_year_id)
                ->where('status', true)
                ->get();

            $siteGlobalFeeList=$SiteFeeList
                ->whereIn('academic_fee_group_id', $FeeGroupsGlobalID)
                ->where('academic_class_id', null)
                ->where('academic_department_id', null);

            $siteClassStudentFeeList=$SiteFeeList
                ->whereIn('academic_fee_group_id', $FeeGroupsClassStudentID)
                ->where('academic_class_id',$request->academic_class_id)
                ->where('academic_student_admission_type_id',$request->academic_student_admission_type_id ?? null)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                    return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                })
                ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                    return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                });

            if($request->academic_student_category_id!=null || $request->academic_student_type_id!=null
                || $request->academic_student_admission_type_id!=null)
            {
                $siteGroupFeeList=$siteClassStudentFeeList;

            }else{
                $siteGroupFeeList=array_merge($siteGlobalFeeList->toArray(), $siteClassStudentFeeList->toArray());
            }

        }

        return $siteGroupFeeList;
    }

    private function returnSiteStudentList(Request $request){

        $data = $request->all();

        if($request->academic_class_id){

            if($request->academic_class_group_present){

                $siteStudentIDs=StudentHistory::with(['student'=>function($query){
                    $query->select('id','username');
                }])
                    ->where('academic_version_id',$request->academic_version_id)
                    ->where('academic_shift_id',$request->academic_shift_id)
                    ->where('academic_year_id',$request->academic_year_id)
                    ->where('academic_class_id',$request->academic_class_id)
                    ->where('status',true)
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                        return $query->where('academic_section_id', $data['academic_section_id']);
                    })
                    ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                        return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                    })
                    ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                        return $query->where('academic_session_id', $data['academic_session_id']);
                    })
                    ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                        return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                    })
                    ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                    })
                    ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })
                    ->orderBy('student_roll_number')
                    ->orderBy('academic_section_id')
                    ->orderBy('academic_class_group_id')
                    ->orderBy('academic_class_id')
                    ->orderBy('academic_department_id')
                    ->get(['id','user_id','student_roll_number']);

            }else{

                $siteStudentIDs=StudentHistory::with(['student'=>function($query){
                    $query->select('id','username');
                }])
                    ->where('academic_version_id',$request->academic_version_id)
                    ->where('academic_shift_id',$request->academic_shift_id)
                    ->where('academic_year_id',$request->academic_year_id)
                    ->where('academic_class_id',$request->academic_class_id)
                    ->where('status',true)
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                        return $query->where('academic_section_id', $data['academic_section_id']);
                    })
                    ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                        return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                    })
                    ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                    })
                    ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })
                    ->orderBy('student_roll_number')
                    ->orderBy('academic_section_id')
                    ->orderBy('academic_class_group_id')
                    ->orderBy('academic_class_id')
                    ->orderBy('academic_department_id')
                    ->get(['id','user_id','student_roll_number']);

            }

        }

        return $siteStudentIDs;

    }

    public function getStudentWaiverTypeBaseWaiverAmount($waiverTypeID, $studentHistoryID){

        $studentWaiverList=null;
        if($waiverTypeID && $studentHistoryID){
            $studentWaiverList=SiteStudentFeeWaiverOfferHistory::where('student_history_id', $studentHistoryID)
                ->where('academic_waiver_type_id', $waiverTypeID)
                ->whereNull('site_student_fee_fine_allocation_id')
                ->where('demand_slip_create_status', false)
                ->orderBy('id', 'desc')
                ->first();
        }

        if($studentWaiverList){
            $waiverAmount=$studentWaiverList->amount;
            $IsPercentage=$studentWaiverList->percantage_status;
        }else{
            $waiverAmount=0;
            $IsPercentage=false;
        }


        return response()->json([$waiverAmount, $IsPercentage], 200, []);


    }

    public function getSiteBaseWaiverTypeList(){

        $waiverList=AcademicWaiverType::get();

        return response()->json($waiverList, 200, []);

    }

    public function createUpdateSiteGroupWaiverGenerate(Request $request){
//        return $request;

        DB::beginTransaction();
        try {

        if($request->instent_waiver_without_sub_head){

            $studentWaiverCheck=SiteStudentFeeWaiverOfferHistory::where('student_history_id', $request->student_history_id)
                ->whereNull('site_student_fee_fine_allocation_id')
                ->where('demand_slip_create_status', false)
                ->orderBy('id', 'desc')
                ->first();

            if($studentWaiverCheck){
                $studentWaiverCheck->academic_waiver_type_id= $request->academic_waiver_type_id;
                $studentWaiverCheck->amount= $request->instent_waiver_amount;
                $studentWaiverCheck->percantage_status= $request->instent_waiver_is_percentage;
                $studentWaiverCheck->save();
            }
            else{
                $WaiverHistory= new SiteStudentFeeWaiverOfferHistory();
                $WaiverHistory->student_history_id= $request->student_history_id;
                $WaiverHistory->academic_waiver_type_id= $request->academic_waiver_type_id;
                $WaiverHistory->amount= $request->instent_waiver_amount;
                $WaiverHistory->percantage_status= $request->instent_waiver_is_percentage;
                $WaiverHistory->status= true;


                $WaiverHistory->save();
            }

        }
        else{
            $this->InsertDataToSiteFeeWaiverOfferHistoryTable($request);
        }



            DB::commit();
            return Response::json(['message' => 'information Save Successfully!', 'mode' => 'Saved!'], 200);

        }  catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (Exception $exception) {
            DB::rollBack();
            return Response::json(['message' => $exception->getMessage()], 410);
        }



    }

    private function InsertDataToSiteFeeWaiverOfferHistoryTable(Request $request){

        $data = $request->all();

        if($request->academic_class_group_present){

            $siteStudentIDs=StudentHistory::where('academic_version_id',$request->academic_version_id)
                ->where('academic_shift_id',$request->academic_shift_id)
                ->where('academic_year_id',$request->academic_year_id)
                ->where('academic_class_id',$request->academic_class_id)
                ->where('status',true)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                    return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                })
                ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                    return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                })
                ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                })
                ->get(['id','user_id']);



        }else{

            $siteStudentIDs=StudentHistory::where('academic_version_id',$request->academic_version_id)
                ->where('academic_shift_id',$request->academic_shift_id)
                ->where('academic_year_id',$request->academic_year_id)
                ->where('academic_class_id',$request->academic_class_id)
                ->where('status',true)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                    return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                })
                ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                    return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                })
                ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                })
                ->get(['id','user_id', 'academic_student_category_id',
                    'academic_student_type_id', 'academic_student_admission_type_id', 'academic_residence_id',
                    'academic_quata_id','academic_transport_id']);

        }



        $siteGroupFeeList=$this->returnSiteGroupFeeList($request);

        $siteGroupFeeListIDs=[];
        foreach ($siteGroupFeeList as $key => $value) {
            $siteGroupFeeListIDs[]=$value['id'];
        }


        if ($request->fee_head_name == 'monthly') {
            $checked_admission_examination_general_ids = $request->select_month_ids;
        } else {
            $checked_admission_examination_general_ids[] = $request->checked_admission_examination_general_id;
        }

        $presentSiteWaiverGenerateList = SiteFeeWaiverOfferHistory::whereIn('fee_head_type_id', $checked_admission_examination_general_ids)
            ->whereIn('site_student_fee_fine_allocation_id', $siteGroupFeeListIDs)
            ->where('academic_waiver_type_id', $request->academic_waiver_type_id)
            ->get();

        $presentSiteStudentWaiverGenerateList = SiteStudentFeeWaiverOfferHistory::whereIn('fee_head_type_id',$checked_admission_examination_general_ids)
            ->whereIn('site_student_fee_fine_allocation_id', $siteGroupFeeListIDs)
            ->where('academic_waiver_type_id', $request->academic_waiver_type_id)
            ->get();

        $chargest = [];
        $charges = [];

        foreach ($checked_admission_examination_general_ids as $ket => $typeid) {


            $presentSiteWaiverGenerate = $presentSiteWaiverGenerateList->where('fee_head_type_id', $typeid);

            $presentSiteStudentWaiverGenerate = $presentSiteStudentWaiverGenerateList->where('fee_head_type_id', $typeid);


            $checkAlreadyPaymentCreate=SiteStudentFeeWaiverOfferHistory::whereIn('site_student_fee_fine_allocation_id',$siteGroupFeeListIDs)
                ->where('fee_head_type_id', $typeid)
                ->where('demand_slip_create_status',true)
                ->first();




            if (!$checkAlreadyPaymentCreate) {


                if (!($request->student_history_id)) {

                    $editedWaiverGenerateIDs=[];
                    foreach ($request->siteBaseWaiverList as $keys => $values) {
                        if ($values['select_fee_sub_head_id']) {

                            $checkPresentSiteWaiverGenerate = $presentSiteWaiverGenerate
                                ->where('site_student_fee_fine_allocation_id', $values['id'])
                                ->first();

                            if ($checkPresentSiteWaiverGenerate) {
                                $editedWaiverGenerateIDs[] = $checkPresentSiteWaiverGenerate->id;

                                if ($checkPresentSiteWaiverGenerate->site_group_id == null){
                                    $checkPresentSiteWaiverGenerate->amount = $values['waiver_amount'];
                                    $checkPresentSiteWaiverGenerate->save();
                                }


                            } else {
                                $chargest[] = [
                                    'site_student_fee_fine_allocation_id' => $values['id'],
                                    'fee_head_type_id' => $typeid,
                                    'academic_waiver_type_id' => $request->academic_waiver_type_id,
                                    'amount' => $values['waiver_amount'],
                                    'percantage_status' => $values['percantage_status'],
                                    'status' => true,
                                    'site_id' => Session::get('SITE_ID'),
                                    'academic_fee_head_id' => $request->checked_fee_head_id,
                                ];
                            }

                        }
                    }



                    if (!$checkAlreadyPaymentCreate) {
                        $siteWaiverGeneratePresentIDArr=$presentSiteWaiverGenerateList->where('fee_head_type_id', $typeid)->pluck('id');
                        $siteWaiverGenerateidCheck=array_diff($siteWaiverGeneratePresentIDArr->toArray(), $editedWaiverGenerateIDs);
                        SiteFeeWaiverOfferHistory::whereIn('id', $siteWaiverGenerateidCheck)->delete();
                    }

                }


            }



            if ($request->student_history_id) {

                $checkAlreadyPaymentCreate=SiteStudentFeeWaiverOfferHistory::whereIn('site_student_fee_fine_allocation_id',$siteGroupFeeListIDs)
                    ->where('fee_head_type_id', $typeid)
                    ->where('student_history_id', $request->student_history_id)
                    ->where('academic_waiver_type_id', $request->academic_waiver_type_id)
                    ->where('demand_slip_create_status',true)
                    ->first();

                if(!$checkAlreadyPaymentCreate){
                    $siteStudentIDsList = StudentHistory::where('id', $request->student_history_id)
                        ->get();
                }else{
                    $siteStudentIDsList=Array();
                }

            }
            else{

                if (!$checkAlreadyPaymentCreate) {
                    $siteStudentIDsList=$siteStudentIDs;
                }else{
                    $siteStudentIDsList=Array();
                }

            }


            if(count($siteStudentIDsList)>0) {

                $editedStudentFeeFenerateIDs=[];
                $studentIDs=[];
                foreach ($siteStudentIDsList as $key => $value) {
                    $studentIDs[]=$value->id;

                    

                    foreach ($request->siteBaseWaiverList as $keys => $values) {

                        if ($values['select_fee_sub_head_id']) {


                            if ($values['academic_fee_sub_head']['head_key'] == 'general') {

                                if ($values['academic_student_category_id']) {
                                    if ($values['academic_student_category_id'] == $value->academic_student_category_id) {


                                        $checkPresentSiteStudentWaiverGenerate = $presentSiteStudentWaiverGenerate
                                            ->where('student_history_id', $value->id)
                                            ->where('site_student_fee_fine_allocation_id', $values['id'])
                                            ->where('fee_head_type_id', $typeid)
                                            ->first();

                                        if ($checkPresentSiteStudentWaiverGenerate) {

                                            $editedStudentFeeFenerateIDs[] = $checkPresentSiteStudentWaiverGenerate->id;


                                            if ($checkPresentSiteStudentWaiverGenerate->site_group_id == null){

                                                $checkPresentSiteStudentWaiverGenerate->amount = $values['waiver_amount'];
                                                $checkPresentSiteStudentWaiverGenerate->percantage_status = $values['percantage_status'];
                                                $checkPresentSiteStudentWaiverGenerate->save();

                                            }

                                        } else {
                                            $charges[] = [
                                                'student_history_id' => $value->id,
                                                'site_student_fee_fine_allocation_id' => $values['id'],
                                                'fee_head_type_id' => $typeid,
                                                'academic_waiver_type_id' => $request->academic_waiver_type_id,
                                                'amount' => $values['waiver_amount'],
                                                'percantage_status' => $values['percantage_status'],
                                                'status' => true,
                                                'site_id' => Session::get('SITE_ID'),
                                                'academic_fee_head_id' => $request->checked_fee_head_id,
                                                'academic_fee_sub_head_id' => $values['academic_fee_sub_head_id'],
                                            ];
                                        }


                                    }
                                } else if ($values['academic_student_admission_type_id']) {
                                    if ($values['academic_student_admission_type_id'] == $value->academic_student_admission_type_id) {

                                        $checkPresentSiteStudentWaiverGenerate = $presentSiteStudentWaiverGenerate
                                            ->where('student_history_id', $value->id)
                                            ->where('site_student_fee_fine_allocation_id', $values['id'])
                                            ->where('fee_head_type_id', $typeid)
                                            ->first();

                                        if ($checkPresentSiteStudentWaiverGenerate) {
                                            $editedStudentFeeFenerateIDs[] = $checkPresentSiteStudentWaiverGenerate->id;

                                            if ($checkPresentSiteStudentWaiverGenerate->site_group_id == null){

                                                $checkPresentSiteStudentWaiverGenerate->amount = $values['waiver_amount'];
                                                $checkPresentSiteStudentWaiverGenerate->percantage_status = $values['percantage_status'];
                                                $checkPresentSiteStudentWaiverGenerate->save();

                                            }

                                        } else {
                                            $charges[] = [
                                                'student_history_id' => $value->id,
                                                'site_student_fee_fine_allocation_id' => $values['id'],
                                                'fee_head_type_id' => $typeid,
                                                'academic_waiver_type_id' => $request->academic_waiver_type_id,
                                                'amount' => $values['waiver_amount'],
                                                'percantage_status' => $values['percantage_status'],
                                                'status' => true,
                                                'site_id' => Session::get('SITE_ID'),
                                                'academic_fee_head_id' => $request->checked_fee_head_id,
                                                'academic_fee_sub_head_id' => $values['academic_fee_sub_head_id'],
                                            ];
                                        }

                                    }
                                } else if ($values['academic_student_type_id']) {
                                    if ($values['academic_student_type_id'] == $value->academic_student_type_id) {

                                        $checkPresentSiteStudentWaiverGenerate = $presentSiteStudentWaiverGenerate
                                            ->where('student_history_id', $value->id)
                                            ->where('site_student_fee_fine_allocation_id', $values['id'])
                                            ->where('fee_head_type_id', $typeid)
                                            ->first();

                                        if ($checkPresentSiteStudentWaiverGenerate) {
                                            $editedStudentFeeFenerateIDs[] = $checkPresentSiteStudentWaiverGenerate->id;

                                            if ($checkPresentSiteStudentWaiverGenerate->site_group_id == null){

                                                $checkPresentSiteStudentWaiverGenerate->amount = $values['waiver_amount'];
                                                $checkPresentSiteStudentWaiverGenerate->percantage_status = $values['percantage_status'];
                                                $checkPresentSiteStudentWaiverGenerate->save();

                                            }

                                        } else {
                                            $charges[] = [
                                                'student_history_id' => $value->id,
                                                'site_student_fee_fine_allocation_id' => $values['id'],
                                                'fee_head_type_id' => $typeid,
                                                'academic_waiver_type_id' => $request->academic_waiver_type_id,
                                                'amount' => $values['waiver_amount'],
                                                'percantage_status' => $values['percantage_status'],
                                                'status' => true,
                                                'site_id' => Session::get('SITE_ID'),
                                                'academic_fee_head_id' => $request->checked_fee_head_id,
                                                'academic_fee_sub_head_id' => $values['academic_fee_sub_head_id'],
                                            ];
                                        }

                                    }
                                } else {
                                    $checkPresentSiteStudentWaiverGenerate = $presentSiteStudentWaiverGenerate
                                        ->where('student_history_id', $value->id)
                                        ->where('site_student_fee_fine_allocation_id', $values['id'])
                                        ->where('fee_head_type_id', $typeid)
                                        ->first();

                                    if ($checkPresentSiteStudentWaiverGenerate) {
                                        $editedStudentFeeFenerateIDs[] = $checkPresentSiteStudentWaiverGenerate->id;

                                        if ($checkPresentSiteStudentWaiverGenerate->site_group_id == null){

                                            $checkPresentSiteStudentWaiverGenerate->amount = $values['waiver_amount'];
                                            $checkPresentSiteStudentWaiverGenerate->percantage_status = $values['percantage_status'];
                                            $checkPresentSiteStudentWaiverGenerate->save();

                                        }

                                    } else {
                                        $charges[] = [
                                            'student_history_id' => $value->id,
                                            'site_student_fee_fine_allocation_id' => $values['id'],
                                            'fee_head_type_id' => $typeid,
                                            'academic_waiver_type_id' => $request->academic_waiver_type_id,
                                            'amount' => $values['waiver_amount'],
                                            'percantage_status' => $values['percantage_status'],
                                            'status' => true,
                                            'site_id' => Session::get('SITE_ID'),
                                            'academic_fee_head_id' => $request->checked_fee_head_id,
                                            'academic_fee_sub_head_id' => $values['academic_fee_sub_head_id'],
                                        ];
                                    }
                                }

                            } else if ($values['academic_fee_sub_head']['head_key'] == 'transport') {

                                if ($value->academic_transport_id) {
                                    if ($values['academic_fee_sub_head']['head_key_base_id'] == $value->academic_transport_id) {

                                        $checkPresentSiteStudentWaiverGenerate = $presentSiteStudentWaiverGenerate
                                            ->where('student_history_id', $value->id)
                                            ->where('site_student_fee_fine_allocation_id', $values['id'])
                                            ->where('fee_head_type_id', $typeid)
                                            ->first();

                                        if ($checkPresentSiteStudentWaiverGenerate) {
                                            $editedStudentFeeFenerateIDs[] = $checkPresentSiteStudentWaiverGenerate->id;

                                            if ($checkPresentSiteStudentWaiverGenerate->site_group_id == null){

                                                $checkPresentSiteStudentWaiverGenerate->amount = $values['waiver_amount'];
                                                $checkPresentSiteStudentWaiverGenerate->percantage_status = $values['percantage_status'];
                                                $checkPresentSiteStudentWaiverGenerate->save();

                                            }

                                        } else {
                                            $charges[] = [
                                                'student_history_id' => $value->id,
                                                'site_student_fee_fine_allocation_id' => $values['id'],
                                                'fee_head_type_id' => $typeid,
                                                'academic_waiver_type_id' => $request->academic_waiver_type_id,
                                                'amount' => $values['waiver_amount'],
                                                'percantage_status' => $values['percantage_status'],
                                                'status' => true,
                                                'site_id' => Session::get('SITE_ID'),
                                                'academic_fee_head_id' => $request->checked_fee_head_id,
                                                'academic_fee_sub_head_id' => $values['academic_fee_sub_head_id'],
                                            ];
                                        }


                                    }
                                }


                            } else if ($values['academic_fee_sub_head']['head_key'] == 'residance') {


                                if ($value->academic_residence_id) {
                                    if ($values['academic_fee_sub_head']['head_key_base_id'] == $value->academic_residence_id) {

                                        $checkPresentSiteStudentWaiverGenerate = $presentSiteStudentWaiverGenerate
                                            ->where('student_history_id', $value->id)
                                            ->where('site_student_fee_fine_allocation_id', $values['id'])
                                            ->where('fee_head_type_id', $typeid)
                                            ->first();

                                        if ($checkPresentSiteStudentWaiverGenerate) {
                                            $editedStudentFeeFenerateIDs[] = $checkPresentSiteStudentWaiverGenerate->id;

                                            if ($checkPresentSiteStudentWaiverGenerate->site_group_id == null){

                                                $checkPresentSiteStudentWaiverGenerate->amount = $values['waiver_amount'];
                                                $checkPresentSiteStudentWaiverGenerate->percantage_status = $values['percantage_status'];
                                                $checkPresentSiteStudentWaiverGenerate->save();

                                            }

                                        } else {
                                            $charges[] = [
                                                'student_history_id' => $value->id,
                                                'site_student_fee_fine_allocation_id' => $values['id'],
                                                'fee_head_type_id' => $typeid,
                                                'academic_waiver_type_id' => $request->academic_waiver_type_id,
                                                'amount' => $values['waiver_amount'],
                                                'percantage_status' => $values['percantage_status'],
                                                'status' => true,
                                                'site_id' => Session::get('SITE_ID'),
                                                'academic_fee_head_id' => $request->checked_fee_head_id,
                                                'academic_fee_sub_head_id' => $values['academic_fee_sub_head_id'],
                                            ];
                                        }

                                    }
                                }

                            } else if ($values['academic_fee_sub_head']['head_key'] == 'gender') {


                                if ($value->gender_id) {
                                    if ($values['academic_fee_sub_head']['head_key_base_id'] == $value->gender_id) {

                                        $checkPresentSiteStudentWaiverGenerate = $presentSiteStudentWaiverGenerate
                                            ->where('student_history_id', $value->id)
                                            ->where('site_student_fee_fine_allocation_id', $values['id'])
                                            ->where('fee_head_type_id', $typeid)
                                            ->first();

                                        if ($checkPresentSiteStudentWaiverGenerate) {
                                            $editedStudentFeeFenerateIDs[] = $checkPresentSiteStudentWaiverGenerate->id;

                                            if ($checkPresentSiteStudentWaiverGenerate->site_group_id == null){

                                                $checkPresentSiteStudentWaiverGenerate->amount = $values['waiver_amount'];
                                                $checkPresentSiteStudentWaiverGenerate->percantage_status = $values['percantage_status'];
                                                $checkPresentSiteStudentWaiverGenerate->save();

                                            }

                                        } else {
                                            $charges[] = [
                                                'student_history_id' => $value->id,
                                                'site_student_fee_fine_allocation_id' => $values['id'],
                                                'fee_head_type_id' => $typeid,
                                                'academic_waiver_type_id' => $request->academic_waiver_type_id,
                                                'amount' => $values['waiver_amount'],
                                                'percantage_status' => $values['percantage_status'],
                                                'status' => true,
                                                'site_id' => Session::get('SITE_ID'),
                                                'academic_fee_head_id' => $request->checked_fee_head_id,
                                                'academic_fee_sub_head_id' => $values['academic_fee_sub_head_id'],
                                            ];
                                        }

                                    }
                                }

                            }
                        

                           

                            ///=== update student fee generate start===
                            
                        //     if($values['select_fee_sub_head_id']){
                        //      //   dd($values);
                          
                        //     $checkStudentFeeGenerate = SiteStudentFeeGenerate::where('student_history_id', $value->id)
                        //         ->where('site_student_fee_fine_allocation_id', $values['id'])
                        //         ->where('fee_head_type_id', $typeid)
                        //         ->where('academic_fee_head_id', $request->checked_fee_head_id)
                        //         ->where('academic_fee_sub_head_id', $values['academic_fee_sub_head_id'])
                        //         ->where('demand_slip_create_status', false)
                        //         ->first();
                        //     if($checkStudentFeeGenerate){

                        //         if($values['percantage_status']){
                        //             $waiver_amount=($values['amount']*$values['waiver_amount'])/100;
                        //             $payable_amount=$checkStudentFeeGenerate->amount-$waiver_amount;

                        //         }else{
                        //             $waiver_amount=$values['waiver_amount'];
                        //             $payable_amount=$values['amount']-$waiver_amount;
                        //         }
                        //         $checkStudentFeeGenerate->payable_amount=$payable_amount;
                        //         $checkStudentFeeGenerate->waiver_amount=$waiver_amount;
                        //         $checkStudentFeeGenerate->save();
                        //     }

                        // }
                          
                            ///=== update student fee generate end===
                      

                        }

                    }


                }


                $siteStudentWaiverGeneratePresentIDArr=$presentSiteStudentWaiverGenerateList
                    ->where('fee_head_type_id', $typeid)
                    ->whereIn('student_history_id', $studentIDs)
                    ->pluck('id');
                $siteStudentWaiverGenerateidCheck=array_diff($siteStudentWaiverGeneratePresentIDArr->toArray(), $editedStudentFeeFenerateIDs);
                $siteStFeeWaiverOfferHis = SiteStudentFeeWaiverOfferHistory::whereIn('id', $siteStudentWaiverGenerateidCheck)->get();

                if(count($siteStFeeWaiverOfferHis)>0){
                    foreach ($siteStFeeWaiverOfferHis as $k => $v){
                        if($v->site_group_id == null){
                            $v->delete();
                        }

                    }



                }


            }




        }



        if(count($chargest)>0){
            SiteFeeWaiverOfferHistory::insert($chargest);
        }


        if(count($charges)>0){
            SiteStudentFeeWaiverOfferHistory::insert($charges);
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
//    public function store(Request $request)
//    {
////        return $request;
//        if($request->status == 1){
//            foreach($request->user_list as $key => $value){
//                if($value['status'] == 1){
//                    foreach ($request->month as  $k => $v){
//
//                        foreach ($request->student_fee_generate_list as  $ke => $sub_head){
//
//                            if($sub_head['status'] == true){
//                                $student_waiver = new SiteStudentWaiverHistory();
//                                $student_waiver->site_waiver_type_id = $request->waiver_type;
//                                $student_waiver->user_id = $value['id'];
//                                $student_waiver->academic_version_id = $request->site_version_id;
//                                $student_waiver->academic_year_id = $request->academic_year;
//                                $student_waiver->academic_shift_id = $request->academic_shift_id;
//                                $student_waiver->academic_class_id =  $request->academic_class_id ?? null;
//                                $student_waiver->academic_department_id =  $request->academic_department_id ?? null;
////                            $student_waiver->academic_department_id =  1;
//                                $student_waiver->academic_class_group_id =  $request->academic_class_group_id ?? null;
//                                $student_waiver->academic_section_id =  $request->academic_section_id ?? null;
//                                $student_waiver->academic_session_id =  $request->academic_session_id ?? null;
//                                $student_waiver->month = $v['id'];
//                                $student_waiver->base = 'subheadbase';
//                                $student_waiver->amount = $sub_head['change_amount'];
//                                $student_waiver->percantage_status = $request->countInPercentage;
//                                $student_waiver->student_waiver_document_id = $request->doc_id;
//                                $student_waiver->academic_fee_sub_head_id = $sub_head['sub_head_id'];
//                                $student_waiver->status = $sub_head["status"];
//                                $student_waiver->save();
//
//                            }else{
//
//                            }
//
//                        }
//
//
//                    }
//
//                }else{
//
//                }
//
//
//
//            }
//        }elseif ($request->status == 0){
//            //return 'ok';
//            foreach($request->user_list as $key => $value){
//
//                if($value['status'] == 1){
//                    foreach ($request->month as  $k => $v){
//
//
//                        $student_waiver = new SiteStudentWaiverHistory();
//                        $student_waiver->site_waiver_type_id = $request->waiver_type;
//                        $student_waiver->user_id = $value['id'];
//                        $student_waiver->academic_version_id = $request->site_version_id;
//                        $student_waiver->academic_year_id = $request->academic_year;
//                        $student_waiver->academic_shift_id = $request->academic_shift_id;
//                        $student_waiver->academic_class_id =  $request->academic_class_id ?? null;
//                        $student_waiver->academic_department_id =  $request->academic_department_id ?? null;
////                        $student_waiver->academic_department_id =  1;
//                        $student_waiver->academic_class_group_id =  $request->academic_class_group_id ?? null;
//                        $student_waiver->academic_section_id =  $request->academic_section_id ?? null;
//                        $student_waiver->academic_session_id =  $request->academic_session_id ?? null;
//                        $student_waiver->month = $v['id'];
//                        $student_waiver->base = 'specialbase';
//                        $student_waiver->amount = $request->amount;
//                        $student_waiver->percantage_status = $request->countInPercentage;
//                        $student_waiver->student_waiver_document_id = $request->doc_id;
//                        $student_waiver->status = true;
//                        $student_waiver->save();
//
//
//                    }
//
//                }else{
//
//                }
//
//
//            }
//        }else{}
//
//
//    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
